#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef ANGKA8X16_H
#define ANGKA8X16_H

#define ANGKA8X16_WIDTH 8
#define ANGKA8X16_HEIGHT -16

static const uint8_t angka8x16[] PROGMEM = {
    0x05, 0x91, // size
    0x08, // width
    0x10, // height
    0x30, // first char
    0x0B, // char count
    
    // char widths
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
    0x08, 
    
    // font data
    0xFC, 0xFE, 0x03, 0x01, 0x01, 0x03, 0xFE, 0xFC, 0x3F, 0x7F, 0xC0, 0x80, 0x80, 0xC0, 0x7F, 0x3F, // 48
    0x04, 0x06, 0x07, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0xFF, 0xFF, 0x80, 0x80, 0x80, // 49
    0x0C, 0x0E, 0x03, 0x01, 0x01, 0x83, 0xFE, 0x7C, 0xF0, 0xF8, 0x8C, 0x86, 0x83, 0x81, 0x80, 0x80, // 50
    0x0C, 0x0E, 0x83, 0x81, 0x81, 0xC3, 0xFE, 0x7C, 0x30, 0x70, 0xC0, 0x80, 0x80, 0xC1, 0x7F, 0x3F, // 51
    0x80, 0xE0, 0x30, 0x1C, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0x07, 0x84, 0x84, 0xFF, 0xFF, 0x84, 0x84, // 52
    0xFF, 0xFF, 0x43, 0x41, 0x41, 0xC1, 0x81, 0x01, 0x30, 0x70, 0xC0, 0x80, 0x80, 0xC0, 0x7F, 0x3F, // 53
    0xC0, 0xF0, 0x9C, 0x86, 0x83, 0x81, 0x01, 0x01, 0x3F, 0x7F, 0xC1, 0x80, 0x80, 0xC1, 0x7F, 0x3E, // 54
    0x01, 0x01, 0x01, 0xC1, 0xE1, 0x31, 0x1F, 0x1F, 0xF0, 0xFE, 0x0F, 0x01, 0x00, 0x00, 0x00, 0x00, // 55
    0x7C, 0xFE, 0xC3, 0x81, 0x81, 0xC3, 0xFE, 0x7C, 0x3E, 0x7F, 0xC1, 0x80, 0x80, 0xC1, 0x7F, 0x3E, // 56
    0x7C, 0xFE, 0x83, 0x01, 0x01, 0x83, 0xFE, 0xFC, 0x80, 0x80, 0x81, 0xC1, 0x61, 0x39, 0x0F, 0x03, // 57
    0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0x00 // 58
    
};

#endif
